/*
 * Decompiled with CFR 0.152.
 */
package codyhuh.unusualfishmod.common.item;

import codyhuh.unusualfishmod.common.entity.item.FallingTreeBlockEntity;
import codyhuh.unusualfishmod.common.entity.util.misc.MovingBlockData;
import codyhuh.unusualfishmod.core.registry.UFEntities;
import codyhuh.unusualfishmod.core.registry.UFSounds;
import codyhuh.unusualfishmod.core.registry.UFTags;
import codyhuh.unusualfishmod.core.registry.UFTiers;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolAction;
import org.jetbrains.annotations.Nullable;

public class RipsawItem
extends AxeItem
implements Vanishable {
    public RipsawItem(Item.Properties p_41383_) {
        super((Tier)UFTiers.RIPPER_SAW, 7.0f, -1.0f, p_41383_);
    }

    public UseAnim m_6164_(ItemStack p_41452_) {
        return UseAnim.BRUSH;
    }

    public InteractionResult m_6225_(UseOnContext cntxt) {
        Player player = cntxt.m_43723_();
        Level level = cntxt.m_43725_();
        BlockPos blockPos = cntxt.m_8083_();
        BlockState state = cntxt.m_43725_().m_8055_(blockPos);
        if (!player.m_6144_() && state.m_204336_(BlockTags.f_13106_) && !level.m_8055_(blockPos.m_7495_()).m_204336_(BlockTags.f_13106_)) {
            player.m_6672_(cntxt.m_43724_());
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(cntxt);
    }

    public void gatherAttachedBlocks(LivingEntity player, BlockPos origin, BlockPos pos, List<BlockPos> list) {
        if (list.size() < 300 && !list.contains(pos)) {
            list.add(pos);
            for (BlockPos blockpos1 : BlockPos.m_121940_((BlockPos)pos.m_7918_(-1, -1, -1), (BlockPos)pos.m_7918_(1, 1, 1))) {
                if (blockpos1.equals((Object)pos) || !(pos.m_203198_((double)origin.m_123341_(), (double)pos.m_123342_(), (double)origin.m_123343_()) < 10.0) || !this.isTreePart(player, blockpos1)) continue;
                this.gatherAttachedBlocks(player, origin, blockpos1.m_7949_(), list);
            }
        }
    }

    public boolean isTreePart(LivingEntity player, BlockPos pos) {
        BlockState state = player.m_9236_().m_8055_(pos);
        if (state.m_60795_() || state.m_204336_(UFTags.UNCHOPPABLE)) {
            return false;
        }
        return state.m_204336_(BlockTags.f_13106_) || state.m_204336_(BlockTags.f_13035_);
    }

    public void m_7373_(ItemStack p_41421_, @Nullable Level p_41422_, List<Component> componentList, TooltipFlag p_41424_) {
        componentList.add((Component)Component.m_237115_((String)"tooltip.ripsaw").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
    }

    public void m_5929_(Level level, LivingEntity user, ItemStack stack, int remainingUseDuration) {
        if (user instanceof Player) {
            LivingEntity living;
            Entity entity;
            EntityHitResult entityResult;
            Player player = (Player)user;
            HitResult hitResult = this.calculateHitResult(player);
            if (hitResult instanceof BlockHitResult) {
                BlockHitResult blockHitResult = (BlockHitResult)hitResult;
                if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
                    BlockState state = level.m_8055_(blockHitResult.m_82425_());
                    BlockPos blockPos = blockHitResult.m_82425_();
                    Direction face = blockHitResult.m_82434_();
                    int i = this.m_8105_(stack) - remainingUseDuration + 1;
                    if (state.m_204336_(BlockTags.f_13106_) && !level.m_8055_(blockPos.m_7495_()).m_204336_(BlockTags.f_13106_)) {
                        ArrayList<BlockPos> gathered = new ArrayList<BlockPos>();
                        this.gatherAttachedBlocks((LivingEntity)player, blockPos, blockPos, gathered);
                        level.m_6801_(user.m_19879_(), blockPos, i);
                        if ((float)i >= this.m_8102_(stack, state) * 1.65f && !gathered.isEmpty()) {
                            Vec3 basePos = blockPos.m_252807_();
                            double x = basePos.m_7096_() + (double)face.m_122429_() * 0.75;
                            double y = basePos.m_7098_();
                            double z = basePos.m_7094_() + (double)face.m_122431_() * 0.75;
                            level.m_6801_(user.m_19879_(), blockPos, -1);
                            for (int j = 0; j < 20; ++j) {
                                int negative = level.f_46441_.m_188499_() ? -1 : 1;
                                level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), x, y, z, (double)((float)face.m_122431_() * level.f_46441_.m_188501_() * (float)negative), 0.0, (double)((float)face.m_122429_() * level.f_46441_.m_188501_() * (float)negative));
                            }
                            ArrayList<MovingBlockData> allData = new ArrayList<MovingBlockData>();
                            for (BlockPos pos : gathered) {
                                BlockState moveState = player.m_9236_().m_8055_(pos);
                                BlockEntity te = player.m_9236_().m_7702_(pos);
                                BlockPos offset = pos.m_121996_((Vec3i)blockPos);
                                MovingBlockData data = new MovingBlockData(moveState, moveState.m_60808_((BlockGetter)player.m_9236_(), pos), offset, te == null ? null : te.m_187482_());
                                player.m_9236_().m_46747_(pos);
                                allData.add(data);
                            }
                            for (BlockPos pos : gathered) {
                                player.m_9236_().m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                            }
                            FallingTreeBlockEntity fallingTree = (FallingTreeBlockEntity)((EntityType)UFEntities.FALLING_TREE.get()).m_20615_(player.m_9236_());
                            fallingTree.m_20219_(Vec3.m_82512_((Vec3i)blockPos));
                            fallingTree.setAllBlockData(FallingTreeBlockEntity.createTagFromData(allData));
                            fallingTree.setPlacementCooldown(1);
                            Vec3 vec3 = Vec3.m_82512_((Vec3i)blockPos).m_82546_(player.m_20182_());
                            float f = -((float)Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_)) * 180.0f / (float)Math.PI;
                            fallingTree.setFallDirection(Direction.m_122364_((double)f));
                            player.m_9236_().m_7967_((Entity)fallingTree);
                            stack.m_41622_(allData.stream().filter(e -> e.getState().m_204336_(BlockTags.f_13106_)).toList().size(), (LivingEntity)player, p_40992_ -> p_40992_.m_21166_(EquipmentSlot.MAINHAND));
                        }
                    }
                }
            }
            if (remainingUseDuration % 15 == 0) {
                player.m_216990_((SoundEvent)UFSounds.SAWING.get());
            }
            if ((entityResult = RipsawItem.getLookAtEntity(player, player.m_9236_(), player.getEntityReach() + 1.0)) != null && (entity = entityResult.m_82443_()) instanceof LivingEntity && (living = (LivingEntity)entity).m_6469_(player.m_269291_().m_269075_(player), this.m_41008_())) {
                stack.m_41622_(1, (LivingEntity)player, p_40665_ -> p_40665_.m_21190_(living.m_7655_()));
            }
        }
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return false;
    }

    private HitResult calculateHitResult(Player pPlayer) {
        return ProjectileUtil.m_278180_((Entity)pPlayer, p_281111_ -> !p_281111_.m_5833_() && p_281111_.m_6087_(), (double)pPlayer.getBlockReach());
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (!level.m_5776_()) {
            player.m_6672_(hand);
        }
        return super.m_7203_(level, player, hand);
    }

    public int m_8105_(ItemStack p_41454_) {
        return 72000;
    }

    public static EntityHitResult getLookAtEntity(Player player, Level level, double range) {
        Vec3 eyePos = player.m_20299_(1.0f);
        Vec3 viewVec = player.m_20252_(1.0f);
        Vec3 endVec = eyePos.m_82520_(viewVec.f_82479_ * range, viewVec.f_82480_ * range, viewVec.f_82481_ * range);
        return ProjectileUtil.m_37304_((Level)level, (Entity)player, (Vec3)eyePos, (Vec3)endVec, (AABB)player.m_20191_().m_82400_(range), e -> e instanceof LivingEntity);
    }
}

